/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.rcs.link;

import com.ibm.hwmca.base.custinfo.CustomerInfoData;
import com.ibm.hwmca.base.custinfo.CustomerInfoManager;
import com.ibm.hwmca.fw.rcs.PathManager;
import com.ibm.hwmca.fw.rcs.RcsConfig;
import com.ibm.hwmca.fw.rcs.RcsControl;
import com.ibm.hwmca.fw.rcs.conndata.ConnectionInfoManager;
import com.ibm.hwmca.fw.rcs.conndata.ConnectivityInfo;
import com.ibm.hwmca.fw.rcs.conndata.PhoneInfo;
import com.ibm.hwmca.fw.rcs.conndata.ServerInfo;
import com.ibm.hwmca.fw.rcs.link.LinkFailedException;
import com.ibm.hwmca.fw.rcs.link.LinkNotConfiguredException;
import com.ibm.hwmca.fw.rcs.link.RcsLink;
import com.ibm.hwmca.fw.rcs.modemcfg.ModemConfigData;
import com.ibm.hwmca.fw.rcs.modemcfg.ModemConfigManager;
import com.ibm.hwmca.fw.rcs.outconn.OutboundConfigData;
import com.ibm.hwmca.fw.rcs.outconn.OutboundConfigManager;
import com.ibm.hwmca.fw.util.Trace;
import java.util.Iterator;
import java.util.List;

public class AttVpnLink
extends RcsLink {
    private static final String TRACE_MASKT = "XRCSLATT";
    private static final String TRACE_MASKF = "XRCSLATF";
    private static final String TRACE_MASKD = "XRCSLATD";
    private static AttVpnLink instance;
    private boolean failOver = false;
    private boolean active = false;

    protected AttVpnLink() {
        super(1, false);
        Trace.trace(TRACE_MASKT, "<-> AttVpnLink()");
    }

    public static RcsLink getInstance() {
        if (instance == null) {
            instance = new AttVpnLink();
        }
        Trace.trace(TRACE_MASKT, "<-> getInstance() [" + instance + "]");
        return instance;
    }

    public boolean activate() throws LinkFailedException, LinkNotConfiguredException {
        Trace.trace(TRACE_MASKT, "--> activate()");
        if (this.isActive()) {
            this.ftrace("Already active.");
            return true;
        }
        if (!this.isConfigured()) {
            throw new LinkNotConfiguredException();
        }
        try {
            int rc = 0;
            OutboundConfigData outConfig = OutboundConfigManager.getOutboundConfigManager().getOutboundConfig();
            ModemConfigData modemConfig = ModemConfigManager.getModemConfigManager().getModemConfig();
            List phoneInfo = outConfig.getPhoneInfo();
            for (int x = 0; x < 3; ++x) {
                rc = RcsControl.queryModem();
                if (rc == 0) {
                    throw new LinkFailedException("Failed to detect a modem (RC:" + rc + ")");
                }
                if (rc != 201) break;
                if (x == 2) {
                    throw new LinkFailedException("Modem currently locked (RC:" + rc + ")");
                }
                try {
                    Thread.sleep(5000L);
                    continue;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            boolean connected = false;
            Iterator i = phoneInfo.iterator();
            while (i.hasNext()) {
                PhoneInfo pInfo = (PhoneInfo)i.next();
                String number = modemConfig.getDialPrefix() + pInfo.getDialString();
                RcsConfig.getRcsConfig().setTemporaryConfigValue("modem_dial_number", number);
                rc = RcsControl.startDial();
                if (rc != 0) continue;
                connected = true;
                break;
            }
            if (!connected) {
                throw new LinkFailedException("Failed to dial (RC: " + rc + ")");
            }
            for (int sdc = 1; sdc <= 2; ++sdc) {
                if (this.failOver && sdc == 1) continue;
                PathManager.getPathManager().setSdc(sdc);
                CustomerInfoData custData = CustomerInfoManager.getCustomerInfoManager().getCustomerInfo();
                String country = custData.getSystemCountryCode();
                String region = custData.getSystemSubdivisionCode();
                ConnectivityInfo connData = ConnectionInfoManager.getConnectionInfoManager().getConnectivityInfo(country, region);
                ServerInfo serverInfo = connData.getServerInfo("Server_VPN");
                String vpnServer = serverInfo == null ? "" : serverInfo.getIpAddress();
                serverInfo = connData.getServerInfo("Server_RS3");
                String rs3Server = serverInfo == null ? "" : serverInfo.getIpAddress();
                String rs3Port = serverInfo == null ? "" : String.valueOf(serverInfo.getPort());
                serverInfo = connData.getServerInfo("Server_SA");
                String sdrServer = serverInfo == null ? "" : serverInfo.getIpAddress();
                serverInfo = connData.getServerInfo("Server_SAS");
                String sasServer = serverInfo == null ? "" : serverInfo.getIpAddress();
                serverInfo = connData.getServerInfo("Server_URSF");
                String ursfServer = serverInfo == null ? "" : serverInfo.getIpAddress();
                RcsConfig cfg = RcsConfig.getRcsConfig();
                cfg.setTemporaryConfigValue("vpn_server", vpnServer);
                cfg.setTemporaryConfigValue("host_rs3", rs3Server);
                cfg.setTemporaryConfigValue("port_rs3", rs3Port);
                cfg.setTemporaryConfigValue("host_sdr", sdrServer);
                cfg.setTemporaryConfigValue("host_sas", sasServer);
                cfg.setTemporaryConfigValue("host_ursf", ursfServer);
                rc = RcsControl.startVpn();
                if (rc != 0) continue;
                this.active = true;
                break;
            }
            if (!this.active) {
                throw new LinkFailedException("Failed to start VPN (RC: " + rc + ")");
            }
        }
        catch (LinkFailedException e) {
            throw e;
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKF, "Exception: " + e);
            throw new LinkFailedException(e);
        }
        Trace.trace(TRACE_MASKT, "<-- activate()");
        return true;
    }

    public void deactivate() {
        Trace.trace(TRACE_MASKT, "--> deactivate()");
        try {
            RcsControl.stopVpn();
            RcsControl.stopDial();
            this.active = false;
            this.failOver = false;
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKF, "Exception: " + e);
        }
        Trace.trace(TRACE_MASKT, "<-- deactivate()");
    }

    public boolean isActive() {
        return this.active;
    }

    public boolean fail() {
        Trace.trace(TRACE_MASKT, "--> fail()");
        boolean fail = false;
        if (!this.failOver) {
            if (this.active) {
                this.deactivate();
            }
            this.failOver = true;
            fail = true;
        } else if (this.active) {
            this.deactivate();
        }
        Trace.trace(TRACE_MASKT, "<-- fail() [" + fail + "]");
        return fail;
    }

    public boolean isConfigured() {
        OutboundConfigData data = OutboundConfigManager.getOutboundConfigManager().getOutboundConfig();
        boolean configured = data.isCallHomeServer() && data.isAllowDial() && super.isConfigured();
        Trace.trace(TRACE_MASKT, "<-> isConfigured() [" + configured + "]");
        return configured;
    }
}

